# Début programme de démonstration des entrées analogique (Graphique/1-voie)
# Ce programme mesure et affiche A0 dans un graphique.

# Le fichier libFenetreGraphiqueTempsReel.py fournit la classe GraphiqueTempsReel.
# GraphiqueTempsReel offre un graphique temps réel a 1 ou deux voies.
# Le fichier libFenetreGraphiqueTempsReel.py doit etre dans le meme répertoire que ce programme.
from libFenetreGraphiqueTempsReel import GraphiqueTempsReel         

# Nous instancions un objet fenetre utilisant la classe "GraphiqueTempsReel".
# Les parametres principaux de la fenetre sont définit par le constructeur.
fenetre = GraphiqueTempsReel(
    nomFenetre="Plug'Uno - acquisition",
    titreFigure="Entrée analogique A0",
    legendeAxeX="(index échantillon)",
    legendeAxeY="(1/Vcc Plug'Uno)",
    legendeVoie1="A0",
    nombrePointSurX=100,
    yMin = 0,
    yMax = 1
)

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
brocheA0 = plugUno.get_pin('a:0:i')
# -> a  : signifie mode analogique
# -> 0  : numéro de la broche (0/1/2/3/4)
# -> i  : mode entré (est seule mode offert part Plug'Uno)

# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno ;
# Définit la fréquence d'échantillonnage.
plugUno.samplingOn( 40 ) # interval de mesure : 40 ms -> 25 Hz

# Définit la fonction qui sera appelé a chaque mesure ADC
def fonctionDeRappelLectureA0(valeurA0):
    # Méthode d'ajout de donné a la volé de la classe GraphiqueTempsReel
    fenetre.ajouterDonnee(valeurA0)

# Indique a l'objet brocheA0 d'appeler la fonction de rappel pour mise a jour ADC.
brocheA0.register_callback(fonctionDeRappelLectureA0)

# Affiche la fenêtre de tracé de graphique
fenetre.afficher()
# Méthode dite "blocante" : 
# -> le programme franchira cette instruction a la fermeture de la fenetre de tracé.

# Fermer la connection a Plug'Uno avant de quitter.
plugUno.exit()

# Met fin a l'exécution du programme Python.
#exit()

# Fin programme de démonstration des entrées analogique (Graphique/1-voie)
